//	Critical Mass Be
//	started 12/7/1997
//	Hamish Carr

#include "CMBoard.h"

CMBoard::CMBoard()							//	default constructor
	{
	int *theCell;							//	pointer to walk with
	int *stop;							//	and a stop mark
	
	theCell = bombs;						//	and the startpoint
	stop = theCell + ARRAY_SIZE;				//	set an endpoint
	for (; theCell < stop; theCell++)			//	walk through all of them
		*theCell = 0;						//	initializing to 0
	} // end of CMBoard default constructor

CMBoard::CMBoard(CMBoard &theBoard)			//	copy constructor
	{
	int *theCell;							//	pointer to walk with
	int *theSourceCell;						//	the corresponding cell in source
	int *stop;							//	and a stop mark
	
	theCell = bombs;						//	and the startpoint
	stop = theCell + ARRAY_SIZE;				//	set an endpoint
	theSourceCell = theBoard.bombs;			//	set the source
	for (; theCell < stop; theCell++)			//	walk through all of them
		{
		*theCell = *theSourceCell;			//	copying the old one
		theSourceCell++;					//	and move this along, too
		} // end of for loop		
	} // end of CMBoard copy constructor
		
int CMBoard::Bombs(int r, int c)				//	accessor for bombs array
	{
	int *temp;							//	temporary pointer variable
	temp = bombs + (r << 3) + c;				//	calculate the position
	return *temp;							//	and return the value
	} // end of Bombs()
	
void CMBoard::AddRedBomb(int r, int c)			//	routine to add a red bomb
	{
	int *temp;							//	temporary pointer variable
	temp = bombs + (r << 3) + c;				//	calculate the position
	(*temp)--;							//	subtract a red bomb
	} // end of AddRedBomb
	
void CMBoard::AddBlueBomb(int r, int c)		//	routine to add a blue bomb
	{
	int *temp;							//	temporary pointer variable
	temp = bombs + (r << 3) + c;				//	calculate the position
	(*temp)++;							//	add a blue bomb
	} // end of AddBlueBomb
	
bool CMBoard::HasRedWon()					//	routine to test for red victory
	{
	int *theCell;							//	pointer to walk with
	int *stop;							//	and a stop mark
	int *stop2;							//	and another stop mark
	
	theCell = bombs + V_STEP + H_STEP;		//	and the startpoint
	stop = bombs + ARRAY_SIZE - V_STEP;		//	set an endpoint
	
	for (; theCell < stop; theCell += 2)		//	move to next line in array
		{
		stop2 = theCell + V_STEP - 2;			//	set the horizontal stop
		for (; theCell < stop2; theCell++)	//	walk along the row
			if (*theCell > 0)				//	i.e. we found a blue bomb
				return false;				//	set the flag
		} // end of outer for loop
	return true;							//	i.e. we found no blue bomb				
	} // end of HasRedWon()

bool CMBoard::HasBlueWon()					//	routine to test for blue victory
	{
	int *theCell;							//	pointer to walk with
	int *stop;							//	and a stop mark
	int *stop2;							//	and another stop mark
	
	theCell = bombs + V_STEP + H_STEP;		//	and the startpoint
	stop = bombs + ARRAY_SIZE - V_STEP;		//	set an endpoint
	
	for (; theCell < stop; theCell += 2)		//	move to next line in array
		{
		stop2 = theCell + V_STEP - 2;			//	set the horizontal stop
		for (; theCell < stop2; theCell++)	//	walk along the row
			if (*theCell < 0)				//	i.e. we found a red bomb
				return false;				//	set the flag
		} // end of outer for loop
	return true;							//	i.e. we found no red bomb				
	} // end of HasRedWon()
	
void CMBoard::ExplodeRed()					//	routine to blow up red bombs
	{
	int *theCell;							//	pointer to walk with
	int *theTestCell;						//	the corresponding cell in test array
	int *stop;							//	and a stop mark
	int *stop2;							//	and another stop mark
	int **explosionQTail;					//	pointer to tail of explosion queue
	
	for (;;)								//	loop forever
		{
		explosionQTail = explosionQueue;		//	reset the queue
		
		if (Evaluate() == BLUE_WIPED_OUT)		//	if the blue player is dead
			return;						//	return early

		theCell = bombs + V_STEP + H_STEP;	//	set the startpoint
		stop = bombs + ARRAY_SIZE - V_STEP;	//	set an endpoint
		theTestCell = redExplosions+ V_STEP + H_STEP;
										//	set the test point
	
		for (; theCell < stop; theCell += 2)	//	move to next line in array
			{
			stop2 = theCell + V_STEP - 2;		//	set the horizontal stop
			for (; theCell < stop2; theCell++)
										//	walk along the row
				{
				if (*theCell <= *theTestCell)//	if there are enough to blow up
					{
					*explosionQTail = theCell;
										//	add to the queue of exploders
					explosionQTail++;		//	and increment it
					} // end of if
				theTestCell++;				//	increment the test pointer
				} // end of inmost for loop
			theTestCell +=2;				//	increment the test pointer
			} // end of middle for loop
		if (explosionQTail == explosionQueue)	//	if there are no explosions to do
			break;						//	leave the main loop
		for (; explosionQTail > explosionQueue; )	
										//	walk down the queue
			{
			explosionQTail--;				//	back up to pop an item
			theCell = *explosionQTail;		//	make theCell point to it
			*theCell = 0;					//	empty it out
			theCell -= V_STEP;				//	step up one row
			*theCell = -abs(*theCell)-1;		//	make sure it's red & subtract 1
			theCell += V_STEP - H_STEP;		//	step to the left position
			*theCell = -abs(*theCell)-1;		//	make sure it's red & subtract 1
			theCell += 2;					//	step to the right position
			*theCell = -abs(*theCell)-1;		//	make sure it's red & subtract 1
			theCell += V_STEP - H_STEP;		//	step to the lower position
			*theCell = -abs(*theCell)-1;		//	make sure it's red & subtract 1
			} // end of loop for explosions
		} // end of outer for loop
	} // end of ExplodeRed()	
		
void CMBoard::ExplodeBlue()					//	routine to blow up blue bombs
	{
	int *theCell;							//	pointer to walk with
	int *theTestCell;						//	the corresponding cell in test array
	int *stop;							//	and a stop mark
	int *stop2;							//	and another stop mark
	int **explosionQTail;					//	pointer to tail of explosion queue
	
	for (;;)								//	loop forever
		{
		explosionQTail = explosionQueue;		//	reset the queue
		
		if (Evaluate() == RED_WIPED_OUT)		//	if the blue player is dead
			return;						//	return early

		theCell = bombs + V_STEP + H_STEP;	//	set the startpoint
		stop = bombs + ARRAY_SIZE - V_STEP;	//	set an endpoint
		theTestCell = blueExplosions+ V_STEP + H_STEP;
										//	set the test point
	
		for (; theCell < stop; theCell += 2)	//	move to next line in array
			{
			stop2 = theCell + V_STEP - 2;		//	set the horizontal stop
			for (; theCell < stop2; theCell++)
										//	walk along the row
				{
				if (*theCell >= *theTestCell)//	if there are enough to blow up
					{
					*explosionQTail = theCell;
										//	add to the queue of exploders
					explosionQTail++;		//	and increment it
					} // end of if
				theTestCell++;				//	increment the test pointer
				} // end of inmost for loop
			theTestCell +=2;				//	increment the test pointer
			} // end of middle for loop
		if (explosionQTail == explosionQueue)	//	if there are no explosions to do
			break;						//	leave the main loop
		for (; explosionQTail > explosionQueue; )	
										//	walk down the queue
			{
			explosionQTail--;				//	back up to pop an item
			theCell = *explosionQTail;		//	make theCell point to it
			*theCell = 0;					//	empty it out
			theCell -= V_STEP;				//	step up one row
			*theCell = abs(*theCell)+1;		//	make sure it's blue & subtract 1
			theCell += V_STEP - H_STEP;		//	step to the left position
			*theCell = abs(*theCell)+1;		//	make sure it's blue & subtract 1
			theCell += 2;					//	step to the right position
			*theCell = abs(*theCell)+1;		//	make sure it's blue & subtract 1
			theCell += V_STEP - H_STEP;		//	stop to the lower position
			*theCell = abs(*theCell)+1;		//	make sure it's blue & subtract 1
			} // end of loop for explosions
		} // end of outer for loop
	} // end of ExplodeBlue()	
	
void CMBoard::ExplodeRed(CMassView &display)	//	routine to show red explosions
	{
	int *theCell;							//	pointer to walk with
	int *theTestCell;						//	the corresponding cell in test array
	int *stop;							//	and a stop mark
	int *stop2;							//	and another stop mark
	int **explosionQTail;					//	pointer to tail of explosion queue
	int **walker;							//	pointer for walking along queue
	
	for (;;)								//	loop forever
		{
		explosionQTail = explosionQueue;		//	reset the queue

		display.ShowBoard(RED_PLAYER, FALSE);	//	show the board
		snooze(display.displaySpeed);			//	sleep for however long

		if (Evaluate() == BLUE_WIPED_OUT)		//	if the blue player is dead
			return;						//	return early
		
		theCell = bombs + V_STEP + H_STEP;		//	set the startpoint
		stop = bombs + ARRAY_SIZE - V_STEP;	//	set an endpoint
		theTestCell = redExplosions + V_STEP + H_STEP;
										//	set the test point
	
		display.displayBoardSemaphore->Acquire();	
										//	make sure we change board atomically

		for (; theCell < stop; theCell += 2)	//	move to next line in array
			{
			stop2 = theCell + V_STEP - 2;		//	set the horizontal stop
			for (; theCell < stop2; theCell++)
										//	walk along the row
				{
				if (*theCell <= *theTestCell)//	if there are enough to blow up
					{
					*explosionQTail = theCell;
										//	add to the queue of exploders
					*theCell = RED_BOOM;	//	set the cell to be an explosion
					explosionQTail++;		//	and increment it
					} // end of if
				theTestCell++;				//	increment the test pointer
				} // end of inmost for loop
			theTestCell +=2;				//	increment the test pointer
			} // end of middle for loop
			
		display.displayBoardSemaphore->Release();	
										//	no more changes - release it for now
										//	so that releases will be balanced when we break

		for (walker = explosionQTail; walker > explosionQueue; )
										//	walk backwards along queue, listing explosions
			{
			walker--;						//	step back
			} // end of walker loop
		
		if (explosionQTail == explosionQueue)	//	if there are no explosions to do
			break;						//	leave the main loop

		display.ShowBoard(RED_PLAYER, TRUE);	//	show the board
		snooze(display.displaySpeed);			//	sleep for however long
			
		display.displayBoardSemaphore->Acquire();	
										//	make sure we change board atomically
		for (; explosionQTail > explosionQueue; )	
										//	walk down the queue
			{
			explosionQTail--;				//	back up to pop an item
			theCell = *explosionQTail;		//	make theCell point to it
			*theCell = 0;					//	empty it out
			theCell -= V_STEP;				//	step up one row
			*theCell = -abs(*theCell)-1;		//	make sure it's red & subtract 1
			theCell += V_STEP - H_STEP;		//	step to the left position
			*theCell = -abs(*theCell)-1;		//	make sure it's red & subtract 1
			theCell += 2;					//	step to the right position
			*theCell = -abs(*theCell)-1;		//	make sure it's red & subtract 1
			theCell += V_STEP - H_STEP;		//	step to the lower position
			*theCell = -abs(*theCell)-1;		//	make sure it's red & subtract 1
			} // end of loop for explosions

		display.displayBoardSemaphore->Release();	
										//	no more changes - release it for now
		} // end of outer for loop
	} // end of ExplodeRed

void CMBoard::ExplodeBlue(CMassView &display)	//	routine to show blue explosions
	{
	int *theCell;							//	pointer to walk with
	int *theTestCell;						//	the corresponding cell in test array
	int *stop;							//	and a stop mark
	int *stop2;							//	and another stop mark
	int **explosionQTail;					//	pointer to tail of explosion queue
	int **walker;							//	pointer for walking along queue
	
	for (;;)								//	loop forever
		{
		explosionQTail = explosionQueue;		//	reset the queue

		display.ShowBoard(BLUE_PLAYER, FALSE);	//	show the board

		if (Evaluate() == RED_WIPED_OUT)		//	if the red player is dead
			return;						//	return early
		snooze(display.displaySpeed);			//	sleep for however long
		
		theCell = bombs + V_STEP + H_STEP;		//	set the startpoint
		stop = bombs + ARRAY_SIZE - V_STEP;	//	set an endpoint
		theTestCell = blueExplosions+ V_STEP + H_STEP;
										//	set the test point
		display.displayBoardSemaphore->Acquire();	
										//	make sure we change board atomically

		for (; theCell < stop; theCell += 2)	//	move to next line in array
			{
			stop2 = theCell + V_STEP - 2;		//	set the horizontal stop
			for (; theCell < stop2; theCell++)	//	walk along the row
				{
				if (*theCell >= *theTestCell)	//	if there are enough to blow up
					{
					*explosionQTail = theCell;
										//	add to the queue of exploders
					*theCell = BLUE_BOOM;	//	and set it to an explosion
					explosionQTail++;		//	and increment it
					} // end of if
				theTestCell++;				//	increment the test pointer
				} // end of inmost for loop
			theTestCell +=2;				//	increment the test pointer
			} // end of middle for loop

		display.displayBoardSemaphore->Release();	
										//	no more changes - release it for now
										//	so that releases will be balanced when we break
												
		for (walker = explosionQTail; walker > explosionQueue; )
										//	walk backwards along queue, listing explosions
			{
			walker--;						//	step back
			} // end of walker loop
		
		if (explosionQTail == explosionQueue)	//	if there are no explosions to do
			break;						//	leave the main loop

		display.ShowBoard(BLUE_PLAYER, TRUE);	//	show the board
		snooze(display.displaySpeed);			//	sleep for however long

		display.displayBoardSemaphore->Acquire();	
										//	make sure we change board atomically
		for (; explosionQTail > explosionQueue; )	
										//	walk down the queue
			{
			explosionQTail--;				//	back up to pop an item
			theCell = *explosionQTail;		//	make theCell point to it
			*theCell = 0;					//	empty it out
			theCell -= V_STEP;				//	step up one row
			*theCell = abs(*theCell)+1;		//	make sure it's red & subtract 1
			theCell += V_STEP - H_STEP;		//	step to the left position
			*theCell = abs(*theCell)+1;		//	make sure it's red & subtract 1
			theCell += 2;					//	step to the right position
			*theCell = abs(*theCell)+1;		//	make sure it's red & subtract 1
			theCell += V_STEP - H_STEP;		//	stop to the lower position
			*theCell = abs(*theCell)+1;		//	make sure it's red & subtract 1
			} // end of loop for explosions

		display.displayBoardSemaphore->Release();	
										//	no more changes - release it for now
		} // end of outer for loop
	} // end of ExplodeBlue
	
void CMBoard::MoveRed(int r, int c)			//	execute a red move
	{
	AddRedBomb(r, c);						//	add the bomb
	ExplodeRed();							//	and do the explosions
	} // end of MoveRed()

void CMBoard::MoveBlue(int r, int c)			//	execute a blue move
	{
	AddBlueBomb(r, c);						//	add the bomb
	ExplodeBlue();							//	and do the explosions
	} // end of MoveBlue()

void CMBoard::MoveRed(int r, int c, CMassView &display)
										//	routine to show red move
	{
	display.displayBoardSemaphore->Acquire();	//	make sure the Draw function works
	AddRedBomb(r, c);						//	add the bomb
	display.displayBoardSemaphore->Release();	//	let go of it
	ExplodeRed(display);					//	do the explosions
	} // end of MoveRed()
	
void CMBoard::MoveBlue(int r, int c, CMassView &display)
										//	routine to show blue move
	{
	display.displayBoardSemaphore->Acquire();	//	make sure the Draw function works
	AddBlueBomb(r, c);						//	add the bomb
	display.displayBoardSemaphore->Release();	//	let go of it
	ExplodeBlue(display);					//	do the explosions
	} // end of MoveBlue()
	
int CMBoard::Evaluate(bool isFirstTurn)			//	evaluate the board's value 
	{
	int *theCell;							//	pointer to walk with
	int *theWeightCell;						//	the corresponding cell in test array
	int *stop;							//	and a stop mark
	int *stop2;							//	and another stop mark
	long value = 0;						//	start with a neutral value
	bool hasRed = false, hasBlue = false;		//	flags for whether a player has been eliminated
	
	theCell = bombs + V_STEP + H_STEP;			//	set the startpoint
	stop = bombs + ARRAY_SIZE - V_STEP;		//	set an endpoint
	theWeightCell = cellWeights + V_STEP + H_STEP;
										//	set the test point
	for (; theCell < stop; theCell += 2)		//	move to next line in array
		{
		stop2 = theCell + V_STEP - 2;			//	set the horizontal stop
		for (; theCell < stop2; theCell++)		//	walk along the row
			{
			if ((!hasRed) && (*theCell < 0))	//	only check if flag not set (fast check)
				hasRed = true;				//	OK.  There are red squares
			else if ((!hasBlue) && (*theCell > 0))
				hasBlue = true;
			value += (*theCell)*(*theWeightCell);
										//	Ooh, that's ugly.  Weight the cell & add
			theWeightCell++;				//	increment the weight pointer
			} // end of loop along rows
		theWeightCell +=2;					//	increment the weight pointer
		} // end of loop down rows
	if (!hasRed)							//	red is first player, so we check that first
		return RED_WIPED_OUT;				//	if there aren't any, red has lost
	if (!hasBlue & !isFirstTurn)				//	check blue next
		return BLUE_WIPED_OUT;				//	if there aren't any, blue has lost
	return value;							//	otherwise, return calculated value
	} // end of Evaluate()

bool CMBoard::IsLegalMove(int r, int c, int player)
										//	test to see if a move is legal
										//	player is assumed to be +/- 1
	{
	return ((Bombs(r, c)*player) >= 0);		//	calculate legality & return it
	} // IsLegalMove
	
void CMBoard::Copy(CMBoard &original)			//	copy a board
	{
	int *theCell;							//	pointer to walk with
	int *theSourceCell;						//	the corresponding cell in source
	int *stop;							//	and a stop mark
	
	theCell = bombs;						//	and the startpoint
	stop = theCell + ARRAY_SIZE;				//	set an endpoint
	theSourceCell = original.bombs;			//	set the source
	for (; theCell < stop; theCell++)			//	walk through all of them
		{
		*theCell = *theSourceCell;			//	copying the old one
		theSourceCell++;					//	and move this along, too
		} // end of for loop		
	} // end of Copy()

	 